﻿
# game/indepth_style.rpy:40
translate piglatin new_gui_17a0326e:

    # e "When you create a new project, Ren'Py will automatically create a GUI - a Graphical User Interface - for it."
    e "Henway ouyay reatecay aay ewnay rojectpay, Enray'Ypay illway automaticallyay reatecay aay Uigay - aay Raphicalgay Seruay Nterfaceiay - orfay itay."

# game/indepth_style.rpy:42
translate piglatin new_gui_12c814ed:

    # e "It defines the look of both in-game interface, like this text box, and out-of-game interface like the main and game menus."
    e "Tiay efinesday hetay ooklay ofay othbay inay-amegay interfaceay, ikelay histay exttay oxbay, anday outay-ofay-amegay interfaceay ikelay hetay ainmay anday amegay enusmay."

# game/indepth_style.rpy:44
translate piglatin new_gui_0a2a73bb:

    # e "The default GUI is meant to be nice enough for a simple project. With a few small changes, it's what you're seeing in this game."
    e "Hetay efaultday Uigay isay eantmay otay ebay icenay enoughay orfay aay implesay rojectpay. Ithway aay ewfay mallsay angeschay, itay'say hatway ouyay'eray eeingsay inay histay amegay."

# game/indepth_style.rpy:46
translate piglatin new_gui_22adf68e:

    # e "The GUI is also meant to be easy for an intermediate creator to customize. Customizing the GUI consists of changing the image files in the gui directory, and changing variables in gui.rpy."
    e "Hetay Uigay isay alsoay eantmay otay ebay easyay orfay anay intermediateay reatorcay otay ustomizecay. Ustomizingcay hetay Uigay onsistscay ofay angingchay hetay imageay ilesfay inay hetay uigay irectoryday, anday angingchay ariablesvay inay uigay.pyray."

# game/indepth_style.rpy:48
translate piglatin new_gui_da21de30:

    # e "At the same time, even when customized, the default GUI might be too recognizable for an extremely polished game. That's why we've made it easy to totally replace."
    e "Taay hetay amesay imetay, evenay henway ustomizedcay, hetay efaultday Uigay ightmay ebay ootay ecognizableray orfay anay extremelyay olishedpay amegay. Hattay'say hyway eway'evay ademay itay easyay otay otallytay eplaceray."

# game/indepth_style.rpy:50
translate piglatin new_gui_45765574:

    # e "We've put an extensive guide to customizing the GUI on the Ren'Py website. So if you want to learn more, visit the {a=https://www.renpy.org/doc/html/gui.html}GUI customization guide{/a}."
    e "Eway'evay utpay anay extensiveay uidegay otay ustomizingcay hetay Uigay onay hetay Enray'Ypay ebsiteway. Osay ifay ouyay antway otay earnlay oremay, isitvay hetay {a=https://www.renpy.org/doc/html/gui.html}Uigay ustomizationcay uidegay{/a}."

# game/indepth_style.rpy:58
translate piglatin styles_fa345a38:

    # e "Ren'Py has a powerful style system that controls what displayables look like."
    e "Enray'Ypay ashay aay owerfulpay ylestay ystemsay hattay ontrolscay hatway isplayablesday ooklay ikelay."

# game/indepth_style.rpy:60
translate piglatin styles_6189ee12:

    # e "While the default GUI uses variables to provide styles with sensible defaults, if you're replacing the GUI or creating your own screens, you'll need to learn about styles yourself."
    e "Hileway hetay efaultday Uigay usesay ariablesvay otay rovidepay ylesstay ithway ensiblesay efaultsday, ifay ouyay'eray eplacingray hetay Uigay oray reatingcay ouryay ownay creenssay, ouyay'llay eednay otay earnlay aboutay ylesstay ourselfyay."

# game/indepth_style.rpy:68
translate piglatin styles_menu_a4a6913e:

    # e "What would you like to know about styles?" nointeract
    e "Hatway ouldway ouyay ikelay otay nowkay aboutay ylesstay?" nointeract

# game/indepth_style.rpy:98
translate piglatin style_basics_9a79ef89:

    # e "Styles let a displayable look different from game to game, or even inside the same game."
    e "Tylessay etlay aay isplayableday ooklay ifferentday omfray amegay otay amegay, oray evenay insideay hetay amesay amegay."

# game/indepth_style.rpy:103
translate piglatin style_basics_48777f2c:

    # e "Both of these buttons use the same displayables. But since different styles have been applied, the buttons look different from each other."
    e "Othbay ofay hesetay uttonsbay useay hetay amesay isplayablesday. Utbay incesay ifferentday ylesstay avehay eenbay applieday, hetay uttonsbay ooklay ifferentday omfray eachay otheray."

# game/indepth_style.rpy:108
translate piglatin style_basics_57704d8c:

    # e "Styles are a combination of information from four different places."
    e "Tylessay areay aay ombinationcay ofay informationay omfray ourfay ifferentday acesplay."

# game/indepth_style.rpy:121
translate piglatin style_basics_144731f6:

    # e "The first place Ren'Py can get style information from is part of a screen. Each displayable created by a screen can take a style name and style properties."
    e "Hetay irstfay aceplay Enray'Ypay ancay etgay ylestay informationay omfray isay artpay ofay aay creensay. Acheay isplayableday reatedcay ybay aay creensay ancay aketay aay ylestay amenay anday ylestay ropertiespay."

# game/indepth_style.rpy:138
translate piglatin style_basics_67e48162:

    # e "When a screen displayable contains text, style properties prefixed with text_ apply to that text."
    e "Henway aay creensay isplayableday ontainscay exttay, ylestay ropertiespay refixedpay ithway ext_tay applyay otay hattay exttay."

# game/indepth_style.rpy:151
translate piglatin style_basics_03516b4a:

    # e "The next is as part of a displayable created in an image statement. Style properties are just arguments to the displayable."
    e "Hetay extnay isay asay artpay ofay aay isplayableday reatedcay inay anay imageay atementstay. Tylesay ropertiespay areay ustjay argumentsay otay hetay isplayableday."

# game/indepth_style.rpy:160
translate piglatin style_basics_ccc0d1ca:

    # egreen "Style properties can also be given as arguments when defining a character."
    egreen "Tylesay ropertiespay ancay alsoay ebay ivengay asay argumentsay henway efiningday aay aracterchay."

# game/indepth_style.rpy:162
translate piglatin style_basics_013ab314:

    # egreen "Arguments beginning with who_ are style properties applied to the character's name, while those beginning with what_ are applied to the character's dialogue."
    egreen "Rgumentsaay eginningbay ithway ho_way areay ylestay ropertiespay applieday otay hetay aracterchay'say amenay, hileway hosetay eginningbay ithway hat_way areay applieday otay hetay aracterchay'say ialogueday."

# game/indepth_style.rpy:164
translate piglatin style_basics_dbe80939:

    # egreen "Style properties that don't have a prefix are also applied to the character's name."
    egreen "Tylesay ropertiespay hattay onday'tay avehay aay refixpay areay alsoay applieday otay hetay aracterchay'say amenay."

# game/indepth_style.rpy:174
translate piglatin style_basics_ac6a8414:

    # e "Finally, there is the the style statement, which creates or changes a named style. By giving Text the style argument, we tell it to use the blue_text style."
    e "Inallyfay, heretay isay hetay hetay ylestay atementstay, hichway reatescay oray angeschay aay amednay ylestay. Ybay ivinggay Exttay hetay ylestay argumentay, eway elltay itay otay useay hetay ue_textblay ylestay."

# game/indepth_style.rpy:180
translate piglatin style_basics_3d9bdff7:

    # e "A style property can inherit from a parent. If a style property is not given in a style, it comes from the parent of that style."
    e "Aay ylestay ropertypay ancay inheritay omfray aay arentpay. Fiay aay ylestay ropertypay isay otnay ivengay inay aay ylestay, itay omescay omfray hetay arentpay ofay hattay ylestay."

# game/indepth_style.rpy:182
translate piglatin style_basics_49c5fbfe:

    # e "By default the parent of the style has the same name, with the prefix up to the the first underscore removed. If the style does not have an underscore in its name, 'default' is used."
    e "Ybay efaultday hetay arentpay ofay hetay ylestay ashay hetay amesay amenay, ithway hetay refixpay upay otay hetay hetay irstfay underscoreay emovedray. Fiay hetay ylestay oesday otnay avehay anay underscoreay inay itsay amenay, 'efaultday' isay useday."

# game/indepth_style.rpy:184
translate piglatin style_basics_6ab170a3:

    # e "For example, blue_text inherits from text, which in turn inherits from default. The default style defines all properties, so it doesn't inherit from anything."
    e "Orfay exampleay, ue_textblay inheritsay omfray exttay, hichway inay urntay inheritsay omfray efaultday. Hetay efaultday ylestay efinesday allay ropertiespay, osay itay oesnday'tay inheritay omfray anythingay."

# game/indepth_style.rpy:190
translate piglatin style_basics_f78117a7:

    # e "The parent can be explicitly changed by giving the style statement an 'is' clause. In this case, we're explictly setting the style to the parent of text."
    e "Hetay arentpay ancay ebay explicitlyay angedchay ybay ivinggay hetay ylestay atementstay anay 'isay' auseclay. Niay histay asecay, eway'eray explictlyay ettingsay hetay ylestay otay hetay arentpay ofay exttay."

# game/indepth_style.rpy:194
translate piglatin style_basics_6007040b:

    # e "Each displayable has a default style name. By default, it's usually the lower-case displayable name, like 'text' for Text, or 'button' for buttons."
    e "Acheay isplayableday ashay aay efaultday ylestay amenay. Ybay efaultday, itay'say usuallyay hetay owerlay-asecay isplayableday amenay, ikelay 'exttay' orfay Exttay, oray 'uttonbay' orfay uttonsbay."

# game/indepth_style.rpy:196
translate piglatin style_basics_35db9a05:

    # e "In a screen, a displayable can be given the style_prefix property to give a prefix for that displayable and its children." id style_basics_35db9a05
    e "Niay aay creensay, aay isplayableday ancay ebay ivengay hetay yle_prefixstay ropertypay otay ivegay aay refixpay orfay hattay isplayableday anday itsay ildrenchay." id style_basics_35db9a05

# game/indepth_style.rpy:198
translate piglatin style_basics_422a87f7:

    # e "For example, a text displayable with a style_prefix of 'help' will be given the style 'help_text'."
    e "Orfay exampleay, aay exttay isplayableday ithway aay yle_prefixstay ofay 'elphay' illway ebay ivengay hetay ylestay 'elp_texthay'."

# game/indepth_style.rpy:200
translate piglatin style_basics_bad2e207:

    # e "Lastly, when a displayable is a button, or inside a button, it can take style prefixes."
    e "Astlylay, henway aay isplayableday isay aay uttonbay, oray insideay aay uttonbay, itay ancay aketay ylestay refixespay."

# game/indepth_style.rpy:202
translate piglatin style_basics_22ed20a1:

    # e "The prefixes idle_, hover_, and insensitive_ are used when the button is unfocused, focused, and unfocusable."
    e "Hetay refixespay idle_ay, over_hay, anday insensitive_ay areay useday henway hetay uttonbay isay unfocuseday, ocusedfay, anday unfocusableay."

# game/indepth_style.rpy:204
translate piglatin style_basics_7a58037e:

    # e "These can be preceded by selected_ to change how the button looks when it represents a selected value or screen."
    e "Hesetay ancay ebay recededpay ybay elected_say otay angechay owhay hetay uttonbay ookslay henway itay epresentsray aay electedsay aluevay oray creensay."

# game/indepth_style.rpy:233
translate piglatin style_basics_0cdcb8c3:

    # e "This screen shows the style prefixes in action. You can click on a button to select it, or click outside to advance."
    e "Histay creensay owsshay hetay ylestay refixespay inay actionay. Ouyay ancay ickclay onay aay uttonbay otay electsay itay, oray ickclay outsideay otay advanceay."

# game/indepth_style.rpy:240
translate piglatin style_basics_aed05094:

    # e "Those are the basics of styles. If GUI customization isn't enough for you, styles let you customize just about everything in Ren'Py."
    e "Hosetay areay hetay asicsbay ofay ylesstay. Fiay Uigay ustomizationcay isnay'tay enoughay orfay ouyay, ylesstay etlay ouyay ustomizecay ustjay aboutay everythingay inay Enray'Ypay."

# game/indepth_style.rpy:253
translate piglatin style_general_81f3c8ff:

    # e "The first group of style properties that we'll go over are the general style properties. These work with every displayable, or at least many different ones."
    e "Hetay irstfay oupgray ofay ylestay ropertiespay hattay eway'llay ogay overay areay hetay eneralgay ylestay ropertiespay. Hesetay orkway ithway everyay isplayableday, oray atay eastlay anymay ifferentday onesay."

# game/indepth_style.rpy:264
translate piglatin style_general_a8d99699:

    # e "Every displayable takes the position properties, which control where it can be placed on screen. Since I've already mentioned them, I won't repeat them here."
    e "Veryeay isplayableday akestay hetay ositionpay ropertiespay, hichway ontrolcay hereway itay ancay ebay acedplay onay creensay. Incesay Iay'evay alreadyay entionedmay hemtay, Iay onway'tay epeatray hemtay erehay."

# game/indepth_style.rpy:275
translate piglatin style_general_58d4a18f:

    # e "The xmaximum and ymaximum properties set the maximum width and height of the displayable, respectively. This will cause Ren'Py to shrink things, if possible."
    e "Hetay maximumxay anday maximumyay ropertiespay etsay hetay aximummay idthway anday eighthay ofay hetay isplayableday, espectivelyray. Histay illway ausecay Enray'Ypay otay rinkshay hingstay, ifay ossiblepay."

# game/indepth_style.rpy:277
translate piglatin style_general_cae9a39f:

    # e "Sometimes, the shrunken size will be smaller than the size given by xmaximum and ymaximum."
    e "Ometimessay, hetay runkenshay izesay illway ebay mallersay hantay hetay izesay ivengay ybay maximumxay anday maximumyay."

# game/indepth_style.rpy:279
translate piglatin style_general_5928c24e:

    # e "Similarly, the xminimum and yminimum properties set the minimum width and height. If the displayable is smaller, Ren'Py will try to make it bigger."
    e "Imilarlysay, hetay minimumxay anday minimumyay ropertiespay etsay hetay inimummay idthway anday eighthay. Fiay hetay isplayableday isay mallersay, Enray'Ypay illway ytray otay akemay itay iggerbay."

# game/indepth_style.rpy:289
translate piglatin style_general_35a8ee5e:

    # e "The xsize and ysize properties set the minimum and maximum size to the same value, fixing the size."
    e "Hetay sizexay anday sizeyay ropertiespay etsay hetay inimummay anday aximummay izesay otay hetay amesay aluevay, ixingfay hetay izesay."

# game/indepth_style.rpy:291
translate piglatin style_general_fcfb0640:

    # e "These only works for displayables than can be resized. Some displayables, like images, can't be made bigger or smaller."
    e "Hesetay onlyay orksway orfay isplayablesday hantay ancay ebay esizedray. Omesay isplayablesday, ikelay imagesay, ancay'tay ebay ademay iggerbay oray mallersay."

# game/indepth_style.rpy:299
translate piglatin style_general_cd5cc97c:

    # e "The area property takes a tuple - a parenthesis bounded list of four items. The first two give the position, and the second two the size."
    e "Hetay areaay ropertypay akestay aay upletay - aay arenthesispay oundedbay istlay ofay ourfay itemsay. Hetay irstfay wotay ivegay hetay ositionpay, anday hetay econdsay wotay hetay izesay."

# game/indepth_style.rpy:308
translate piglatin style_general_e5a58f0b:

    # e "Finally, the alt property changes the text used by self-voicing for the hearing impaired."
    e "Inallyfay, hetay altay ropertypay angeschay hetay exttay useday ybay elfsay-oicingvay orfay hetay earinghay impaireday."

# game/indepth_style.rpy:335
translate piglatin style_text_fe457b8f:

    # e "The text style properties apply to text and input displayables."
    e "Hetay exttay ylestay ropertiespay applyay otay exttay anday inputay isplayablesday."

# game/indepth_style.rpy:337
translate piglatin style_text_7ab53f03:

    # e "Text displayables can be created implicitly or explicitly. For example, a textbutton creates a text displayable with a style ending in button_text."
    e "Exttay isplayablesday ancay ebay reatedcay implicitlyay oray explicitlyay. Orfay exampleay, aay extbuttontay reatescay aay exttay isplayableday ithway aay ylestay endingay inay utton_textbay."

# game/indepth_style.rpy:339
translate piglatin style_text_6dd42a57:

    # e "These can also be set in gui.rpy by changing or defining variables with names like gui.button_text_size."
    e "Hesetay ancay alsoay ebay etsay inay uigay.pyray ybay angingchay oray efiningday ariablesvay ithway amesnay ikelay uigay.utton_text_sizebay."

# game/indepth_style.rpy:347
translate piglatin style_text_c689130e:

    # e "The bold style property makes the text bold. This can be done using an algorithm, rather than a different version of the font."
    e "Hetay oldbay ylestay ropertypay akesmay hetay exttay oldbay. Histay ancay ebay oneday usingay anay algorithmay, atherray hantay aay ifferentday ersionvay ofay hetay ontfay."

# game/indepth_style.rpy:355
translate piglatin style_text_3420bfe4:

    # e "The color property changes the color of the text. It takes hex color codes, just like everything else in Ren'Py."
    e "Hetay olorcay ropertypay angeschay hetay olorcay ofay hetay exttay. Tiay akestay exhay olorcay odescay, ustjay ikelay everythingay elseay inay Enray'Ypay."

# game/indepth_style.rpy:363
translate piglatin style_text_14bd6327:

    # e "The first_indent style property determines how far the first line is indented."
    e "Hetay irst_indentfay ylestay ropertypay eterminesday owhay arfay hetay irstfay inelay isay indenteday."

# game/indepth_style.rpy:371
translate piglatin style_text_779ac517:

    # e "The font style property changes the font the text uses. Ren'Py takes TrueType and OpenType fonts, and you'll have to include the font file as part of your visual novel."
    e "Hetay ontfay ylestay ropertypay angeschay hetay ontfay hetay exttay usesay. Enray'Ypay akestay Ruetypetay anday Pentypeoay ontsfay, anday ouyay'llay avehay otay includeay hetay ontfay ilefay asay artpay ofay ouryay isualvay ovelnay."

# game/indepth_style.rpy:379
translate piglatin style_text_917e2bca:

    # e "The size property changes the size of the text."
    e "Hetay izesay ropertypay angeschay hetay izesay ofay hetay exttay."

# game/indepth_style.rpy:388
translate piglatin style_text_1a46cd43:

    # e "The italic property makes the text italic. Again, this is better done with a font, but for short amounts of text Ren'Py can do it for you."
    e "Hetay italicay ropertypay akesmay hetay exttay italicay. Gainaay, histay isay etterbay oneday ithway aay ontfay, utbay orfay ortshay amountsay ofay exttay Enray'Ypay ancay oday itay orfay ouyay."

# game/indepth_style.rpy:397
translate piglatin style_text_472f382d:

    # e "The justify property makes the text justified, lining all but the last line up on the left and the right side."
    e "Hetay ustifyjay ropertypay akesmay hetay exttay ustifiedjay, ininglay allay utbay hetay astlay inelay upay onay hetay eftlay anday hetay ightray idesay."

# game/indepth_style.rpy:405
translate piglatin style_text_87b075f8:

    # e "The kerning property kerns the text. When it's negative, characters are closer together. When positive, characters are farther apart."
    e "Hetay erningkay ropertypay ernskay hetay exttay. Henway itay'say egativenay, aracterschay areay oserclay ogethertay. Henway ositivepay, aracterschay areay artherfay apartay."

# game/indepth_style.rpy:415
translate piglatin style_text_fe7dec14:

    # e "The line_leading and line_spacing properties put spacing before each line, and between lines, respectively."
    e "Hetay ine_leadinglay anday ine_spacinglay ropertiespay utpay pacingsay eforebay eachay inelay, anday etweenbay ineslay, espectivelyray."

# game/indepth_style.rpy:424
translate piglatin style_text_aee9277a:

    # e "The outlines property puts outlines around text. This takes a list of tuples, which is a bit complicated."
    e "Hetay outlinesay ropertypay utspay outlinesay arounday exttay. Histay akestay aay istlay ofay uplestay, hichway isay aay itbay omplicatedcay."

# game/indepth_style.rpy:426
translate piglatin style_text_b4c5190f:

    # e "But if you ignore the brackets and parenthesis, you have the width of the outline, the color, and then horizontal and vertical offsets."
    e "Utbay ifay ouyay ignoreay hetay acketsbray anday arenthesispay, ouyay avehay hetay idthway ofay hetay outlineay, hetay olorcay, anday hentay orizontalhay anday erticalvay offsetsay."

# game/indepth_style.rpy:434
translate piglatin style_text_5a0c2c02:

    # e "The rest_indent property controls the indentation of lines after the first one."
    e "Hetay est_indentray ropertypay ontrolscay hetay indentationay ofay ineslay afteray hetay irstfay oneay."

# game/indepth_style.rpy:443
translate piglatin style_text_430c1959:

    # e "The textalign property controls the positioning of multiple lines of text inside the text displayable. For example, 0.5 means centered." id style_text_430c1959
    e "Hetay extaligntay ropertypay ontrolscay hetay ositioningpay ofay ultiplemay ineslay ofay exttay insideay hetay exttay isplayableday. Orfay exampleay, 0.5 eansmay enteredcay." id style_text_430c1959

# game/indepth_style.rpy:445
translate piglatin style_text_19aa0833:

    # e "It doesn't change the position of the text displayable itself. For that, you'll often want to set the textalign and xalign to the same value." id style_text_19aa0833
    e "Tiay oesnday'tay angechay hetay ositionpay ofay hetay exttay isplayableday itselfay. Orfay hattay, ouyay'llay oftenay antway otay etsay hetay extaligntay anday alignxay otay hetay amesay aluevay." id style_text_19aa0833

# game/indepth_style.rpy:455
translate piglatin style_text_efc3c392:

    # e "When both textalign and xalign are set to 1.0, the text is properly right-justified." id style_text_efc3c392
    e "Henway othbay extaligntay anday alignxay areay etsay otay 1.0, hetay exttay isay roperlypay ightray-ustifiedjay." id style_text_efc3c392

# game/indepth_style.rpy:464
translate piglatin style_text_43be63b9:

    # e "The underline property underlines the text."
    e "Hetay underlineay ropertypay underlinesay hetay exttay."

# game/indepth_style.rpy:471
translate piglatin style_text_343f6d34:

    # e "Those are the most common text style properties, but not the only ones. Here are a few more that you might need in special circumstances."
    e "Hosetay areay hetay ostmay ommoncay exttay ylestay ropertiespay, utbay otnay hetay onlyay onesay. Erehay areay aay ewfay oremay hattay ouyay ightmay eednay inay pecialsay ircumstancescay."

# game/indepth_style.rpy:479
translate piglatin style_text_e7204a95:

    # e "By default, text in Ren'Py is antialiased, to smooth the edges. The antialias property can turn that off, and make the text a little more jagged."
    e "Ybay efaultday, exttay inay Enray'Ypay isay antialiaseday, otay moothsay hetay edgesay. Hetay antialiasay ropertypay ancay urntay hattay offay, anday akemay hetay exttay aay ittlelay oremay aggedjay."

# game/indepth_style.rpy:487
translate piglatin style_text_a5316e4c:

    # e "The adjust_spacing property is a very subtle one, that only matters when a player resizes the window. When True, characters will be shifted a bit so the Text has the same relative spacing."
    e "Hetay adjust_spacingay ropertypay isay aay eryvay ubtlesay oneay, hattay onlyay attersmay henway aay ayerplay esizesray hetay indowway. Henway Ruetay, aracterschay illway ebay iftedshay aay itbay osay hetay Exttay ashay hetay amesay elativeray pacingsay."

# game/indepth_style.rpy:496
translate piglatin style_text_605d4e4a:

    # e "When False, the text won't jump around as much. But it can be a little wider or narrower based on screen size."
    e "Henway Alsefay, hetay exttay onway'tay umpjay arounday asay uchmay. Utbay itay ancay ebay aay ittlelay iderway oray arrowernay asedbay onay creensay izesay."

# game/indepth_style.rpy:505
translate piglatin style_text_acf8a0e1:

    # e "The layout property has a few special values that control where lines are broken. The 'nobreak' value disables line breaks entirely, making the text wider."
    e "Hetay ayoutlay ropertypay ashay aay ewfay pecialsay aluesvay hattay ontrolcay hereway ineslay areay okenbray. Hetay 'obreaknay' aluevay isablesday inelay eaksbray entirelyay, akingmay hetay exttay iderway."

# game/indepth_style.rpy:516
translate piglatin style_text_785729cf:

    # e "When the layout property is set to 'subtitle', the line breaking algorithm is changed to try to make all lines even in length, as subtitles usually are."
    e "Henway hetay ayoutlay ropertypay isay etsay otay 'ubtitlesay', hetay inelay eakingbray algorithmay isay angedchay otay ytray otay akemay allay ineslay evenay inay engthlay, asay ubtitlessay usuallyay areay."

# game/indepth_style.rpy:524
translate piglatin style_text_9c26f218:

    # e "The strikethrough property draws a line through the text. It seems pretty unlikely you'd want to use this one."
    e "Hetay rikethroughstay ropertypay rawsday aay inelay hroughtay hetay exttay. Tiay eemssay rettypay unlikelyay ouyay'day antway otay useay histay oneay."

# game/indepth_style.rpy:534
translate piglatin style_text_c7229243:

    # e "The vertical style property places text in a vertical layout. It's meant for Asian languages with special fonts."
    e "Hetay erticalvay ylestay ropertypay acesplay exttay inay aay erticalvay ayoutlay. Tiay'say eantmay orfay Sianaay anguageslay ithway pecialsay ontsfay."

# game/indepth_style.rpy:540
translate piglatin style_text_724bd5e0:

    # e "And those are the text style properties. There might be a lot of them, but we want to give you a lot of control over how you present text to your players."
    e "Ndaay hosetay areay hetay exttay ylestay ropertiespay. Heretay ightmay ebay aay otlay ofay hemtay, utbay eway antway otay ivegay ouyay aay otlay ofay ontrolcay overay owhay ouyay resentpay exttay otay ouryay ayersplay."

# game/indepth_style.rpy:580
translate piglatin style_button_300b6af5:

    # e "Next up, we have the window and button style properties. These apply to windows like the text window at the bottom of this screen and frames like the ones we show examples in."
    e "Extnay upay, eway avehay hetay indowway anday uttonbay ylestay ropertiespay. Hesetay applyay otay indowsway ikelay hetay exttay indowway atay hetay ottombay ofay histay creensay anday amesfray ikelay hetay onesay eway owshay examplesay inay."

# game/indepth_style.rpy:582
translate piglatin style_button_255a18e4:

    # e "These properties also apply to buttons, in-game and out-of-game. To Ren'Py, a button is a window you can click."
    e "Hesetay ropertiespay alsoay applyay otay uttonsbay, inay-amegay anday outay-ofay-amegay. Otay Enray'Ypay, aay uttonbay isay aay indowway ouyay ancay ickclay."

# game/indepth_style.rpy:593
translate piglatin style_button_9b53ce93:

    # e "I'll start off with this style, which everything will inherit from. To make our lives easier, it inherits from the default style, rather than the customized buttons in this game's GUI." id style_button_9b53ce93
    e "Iay'llay artstay offay ithway histay ylestay, hichway everythingay illway inheritay omfray. Otay akemay ouray iveslay easieray, itay inheritsay omfray hetay efaultday ylestay, atherray hantay hetay ustomizedcay uttonsbay inay histay amegay'say Uigay." id style_button_9b53ce93

# game/indepth_style.rpy:595
translate piglatin style_button_aece4a8c:

    # e "The first style property is the background property. It adds a background to a button or window. Since this is a button, idle and hover variants choose different backgrounds when focused." id style_button_aece4a8c
    e "Hetay irstfay ylestay ropertypay isay hetay ackgroundbay ropertypay. Tiay addsay aay ackgroundbay otay aay uttonbay oray indowway. Incesay histay isay aay uttonbay, idleay anday overhay ariantsvay oosechay ifferentday ackgroundsbay henway ocusedfay." id style_button_aece4a8c

# game/indepth_style.rpy:597
translate piglatin style_button_b969f04a:

    # e "We also center the two buttons, using the xalign position property."
    e "Eway alsoay entercay hetay wotay uttonsbay, usingay hetay alignxay ositionpay ropertypay."

# game/indepth_style.rpy:601
translate piglatin style_button_269ae069:

    # e "We've also customized the style of the button's text, using this style. It centers the text and makes it change color when hovered."
    e "Eway'evay alsoay ustomizedcay hetay ylestay ofay hetay uttonbay'say exttay, usingay histay ylestay. Tiay enterscay hetay exttay anday akesmay itay angechay olorcay henway overedhay."

# game/indepth_style.rpy:612
translate piglatin style_button_1009f3e1:

    # e "Without any padding around the text, the button looks odd. Ren'Py has padding properties that add space inside the button's background."
    e "Ithoutway anyay addingpay arounday hetay exttay, hetay uttonbay ookslay odday. Enray'Ypay ashay addingpay ropertiespay hattay adday pacesay insideay hetay uttonbay'say ackgroundbay."

# game/indepth_style.rpy:621
translate piglatin style_button_5bdfa45a:

    # e "More commonly used are the xpadding and ypadding style properties, which add the same padding to the left and right, or the top and bottom, respectively."
    e "Oremay ommonlycay useday areay hetay paddingxay anday paddingyay ylestay ropertiespay, hichway adday hetay amesay addingpay otay hetay eftlay anday ightray, oray hetay optay anday ottombay, espectivelyray."

# game/indepth_style.rpy:629
translate piglatin style_button_81283d42:

    # e "The margin style properties work the same way, except they add space outside the background. The full set exists: left_margin, right_margin, top_margin, bottom_margin, xmargin, and ymargin."
    e "Hetay arginmay ylestay ropertiespay orkway hetay amesay ayway, exceptay heytay adday pacesay outsideay hetay ackgroundbay. Hetay ullfay etsay existsay: eft_marginlay, ight_marginray, op_margintay, ottom_marginbay, marginxay, anday marginyay."

# game/indepth_style.rpy:638
translate piglatin style_button_0b7aca6b:

    # e "The size_group style property takes a string. Ren'Py will make sure that all the windows or buttons with the same size_group string are the same size."
    e "Hetay ize_groupsay ylestay ropertypay akestay aay ringstay. Enray'Ypay illway akemay uresay hattay allay hetay indowsway oray uttonsbay ithway hetay amesay ize_groupsay ringstay areay hetay amesay izesay."

# game/indepth_style.rpy:647
translate piglatin style_button_4c6da7d9:

    # e "Alternatively, the xfill and yfill style properties make a button take up all available space in the horizontal or vertical directions."
    e "Lternativelyaay, hetay fillxay anday fillyay ylestay ropertiespay akemay aay uttonbay aketay upay allay availableay pacesay inay hetay orizontalhay oray erticalvay irectionsday."

# game/indepth_style.rpy:657
translate piglatin style_button_fd5338b2:

    # e "The foreground property gives a displayable that is placed on top of the contents and background of the window or button."
    e "Hetay oregroundfay ropertypay ivesgay aay isplayableday hattay isay acedplay onay optay ofay hetay ontentscay anday ackgroundbay ofay hetay indowway oray uttonbay."

# game/indepth_style.rpy:659
translate piglatin style_button_b8af697c:

    # e "One way to use it is to provide extra decorations to a button that's serving as a checkbox. Another would be to use it with a Frame to provide a glossy shine that overlays the button's contents."
    e "Neoay ayway otay useay itay isay otay rovidepay extraay ecorationsday otay aay uttonbay hattay'say ervingsay asay aay eckboxchay. Notheraay ouldway ebay otay useay itay ithway aay Ramefay otay rovidepay aay ossyglay ineshay hattay overlaysay hetay uttonbay'say ontentscay."

# game/indepth_style.rpy:668
translate piglatin style_button_c0b1b62e:

    # e "There are also a few style properties that only apply to buttons. The hover_sound and activate_sound properties play sound files when a button is focused and activated, respectively."
    e "Heretay areay alsoay aay ewfay ylestay ropertiespay hattay onlyay applyay otay uttonsbay. Hetay over_soundhay anday activate_sounday ropertiespay ayplay oundsay ilesfay henway aay uttonbay isay ocusedfay anday activateday, espectivelyray."

# game/indepth_style.rpy:677
translate piglatin style_button_02fa647e:

    # e "Finally, the focus_mask property applies to partially transparent buttons. When it's set to True, only areas of the button that aren't transparent cause a button to focus."
    e "Inallyfay, hetay ocus_maskfay ropertypay appliesay otay artiallypay ansparenttray uttonsbay. Henway itay'say etsay otay Ruetay, onlyay areasay ofay hetay uttonbay hattay arenay'tay ansparenttray ausecay aay uttonbay otay ocusfay."

# game/indepth_style.rpy:757
translate piglatin style_bar_414d454a:

    # e "To demonstrate styles, let me first show two of the images we'll be using. This is the image we're using for parts of the bar that are empty."
    e "Otay emonstrateday ylesstay, etlay emay irstfay owshay wotay ofay hetay imagesay eway'llay ebay usingay. Histay isay hetay imageay eway'eray usingay orfay artspay ofay hetay arbay hattay areay emptyay."

# game/indepth_style.rpy:761
translate piglatin style_bar_9422b7b0:

    # e "And here's what we use for parts of the bar that are full."
    e "Ndaay erehay'say hatway eway useay orfay artspay ofay hetay arbay hattay areay ullfay."

# game/indepth_style.rpy:773
translate piglatin style_bar_8ae6a14b:

    # e "The left_bar and right_bar style properties, and their hover variants, give displayables for the left and right side of the bar. By default, the value is shown on the left."
    e "Hetay eft_barlay anday ight_barray ylestay ropertiespay, anday heirtay overhay ariantsvay, ivegay isplayablesday orfay hetay eftlay anday ightray idesay ofay hetay arbay. Ybay efaultday, hetay aluevay isay ownshay onay hetay eftlay."

# game/indepth_style.rpy:775
translate piglatin style_bar_7f0f50e5:

    # e "Also by default, both the left and right displayables are rendered at the full width of the bar, and then cropped to the appropriate size."
    e "Lsoaay ybay efaultday, othbay hetay eftlay anday ightray isplayablesday areay enderedray atay hetay ullfay idthway ofay hetay arbay, anday hentay roppedcay otay hetay appropriateay izesay."

# game/indepth_style.rpy:777
translate piglatin style_bar_9ef4f62f:

    # e "We give the bar the ysize property to set how tall it is. We could also give it xsize to choose how wide, but here it's limited by the width of the frame it's in."
    e "Eway ivegay hetay arbay hetay sizeyay ropertypay otay etsay owhay alltay itay isay. Eway ouldcay alsoay ivegay itay sizexay otay oosechay owhay ideway, utbay erehay itay'say imitedlay ybay hetay idthway ofay hetay amefray itay'say inay."

# game/indepth_style.rpy:790
translate piglatin style_bar_d4c29710:

    # e "When the bar_invert style property is True, the bar value is displayed on the right side of the bar. The left_bar and right_bar displayables might also need to be swapped."
    e "Henway hetay ar_invertbay ylestay ropertypay isay Ruetay, hetay arbay aluevay isay isplayedday onay hetay ightray idesay ofay hetay arbay. Hetay eft_barlay anday ight_barray isplayablesday ightmay alsoay eednay otay ebay wappedsay."

# game/indepth_style.rpy:804
translate piglatin style_bar_cca67222:

    # e "The bar_resizing style property causes the bar images to be resized to represent the value, rather than being rendered at full size and cropped."
    e "Hetay ar_resizingbay ylestay ropertypay ausescay hetay arbay imagesay otay ebay esizedray otay epresentray hetay aluevay, atherray hantay eingbay enderedray atay ullfay izesay anday roppedcay."

# game/indepth_style.rpy:817
translate piglatin style_bar_7d361bac:

    # e "The thumb style property gives a thumb image, that's placed based on the bar's value. In the case of a scrollbar, it's resized if possible." id style_bar_7d361bac
    e "Hetay humbtay ylestay ropertypay ivesgay aay humbtay imageay, hattay'say acedplay asedbay onay hetay arbay'say aluevay. Niay hetay asecay ofay aay crollbarsay, itay'say esizedray ifay ossiblepay." id style_bar_7d361bac

# game/indepth_style.rpy:819
translate piglatin style_bar_b6dfb61b:

    # e "Here, we use it with the base_bar style property, which sets both bar images to the same displayable."
    e "Erehay, eway useay itay ithway hetay ase_barbay ylestay ropertypay, hichway etssay othbay arbay imagesay otay hetay amesay isplayableday."

# game/indepth_style.rpy:834
translate piglatin style_bar_996466ad:

    # e "The left_gutter and right_gutter properties set a gutter on the left or right size of the bar. The gutter is space the bar can't be dragged into, that can be used for borders."
    e "Hetay eft_gutterlay anday ight_gutterray ropertiespay etsay aay uttergay onay hetay eftlay oray ightray izesay ofay hetay arbay. Hetay uttergay isay pacesay hetay arbay ancay'tay ebay raggedday intoay, hattay ancay ebay useday orfay ordersbay."

# game/indepth_style.rpy:849
translate piglatin style_bar_fa41a83c:

    # e "The bar_vertical style property displays a vertically oriented bar. All of the other properties change names - left_bar becomes top_bar, while right_bar becomes bottom_bar."
    e "Hetay ar_verticalbay ylestay ropertypay isplaysday aay erticallyvay orienteday arbay. Llaay ofay hetay otheray ropertiespay angechay amesnay - eft_barlay ecomesbay op_bartay, hileway ight_barray ecomesbay ottom_barbay."

# game/indepth_style.rpy:854
translate piglatin style_bar_5d33c5dc:

    # e "Finally, there's one style we can't show here, and it's unscrollable. It controls what happens when a scrollbar can't be moved at all."
    e "Inallyfay, heretay'say oneay ylestay eway ancay'tay owshay erehay, anday itay'say unscrollableay. Tiay ontrolscay hatway appenshay henway aay crollbarsay ancay'tay ebay ovedmay atay allay."

# game/indepth_style.rpy:856
translate piglatin style_bar_e8e32280:

    # e "By default, it's shown. But if unscrollable is 'insensitive', the bar becomes insensitive. If it's 'hide', the bar is hidden, but still takes up space."
    e "Ybay efaultday, itay'say ownshay. Utbay ifay unscrollableay isay 'insensitiveay', hetay arbay ecomesbay insensitiveay. Fiay itay'say 'idehay', hetay arbay isay iddenhay, utbay illstay akestay upay pacesay."

# game/indepth_style.rpy:860
translate piglatin style_bar_f1292000:

    # e "That's it for the bar properties. By using them, a creator can customize bars, scrollbars, and sliders."
    e "Hattay'say itay orfay hetay arbay ropertiespay. Ybay usingay hemtay, aay reatorcay ancay ustomizecay arsbay, crollbarssay, anday idersslay."

# game/indepth_style.rpy:959
translate piglatin style_box_5fd535f4:

    # e "The hbox displayable is used to lay its children out horizontally. By default, there's no spacing between children, so they run together."
    e "Hetay boxhay isplayableday isay useday otay aylay itsay ildrenchay outay orizontallyhay. Ybay efaultday, heretay'say onay pacingsay etweenbay ildrenchay, osay heytay unray ogethertay."

# game/indepth_style.rpy:965
translate piglatin style_box_0111e5dc:

    # e "Similarly, the vbox displayable is used to lay its children out vertically. Both support style properties that control placement."
    e "Imilarlysay, hetay boxvay isplayableday isay useday otay aylay itsay ildrenchay outay erticallyvay. Othbay upportsay ylestay ropertiespay hattay ontrolcay acementplay."

# game/indepth_style.rpy:970
translate piglatin style_box_5a44717b:

    # e "To make the size of the box displayable obvious, I'll add a highlight to the box itself, and not the frame containing it."
    e "Otay akemay hetay izesay ofay hetay oxbay isplayableday obviousay, Iay'llay adday aay ighlighthay otay hetay oxbay itselfay, anday otnay hetay amefray ontainingcay itay."

# game/indepth_style.rpy:978
translate piglatin style_box_239e7a8f:

    # e "Boxes support the xfill and yfill style properties. These properties make a box expand to fill the available space, rather than the space of the largest child."
    e "Oxesbay upportsay hetay fillxay anday fillyay ylestay ropertiespay. Hesetay ropertiespay akemay aay oxbay expanday otay illfay hetay availableay pacesay, atherray hantay hetay pacesay ofay hetay argestlay ildchay."

# game/indepth_style.rpy:988
translate piglatin style_box_e513c946:

    # e "The spacing style property takes a value in pixels, and adds that much spacing between each child of the box."
    e "Hetay pacingsay ylestay ropertypay akestay aay aluevay inay ixelspay, anday addsay hattay uchmay pacingsay etweenbay eachay ildchay ofay hetay oxbay."

# game/indepth_style.rpy:998
translate piglatin style_box_6ae4f94d:

    # e "The first_spacing style property is similar, but it only adds space between the first and second children. This is useful when the first child is a title that needs different spacing."
    e "Hetay irst_spacingfay ylestay ropertypay isay imilarsay, utbay itay onlyay addsay pacesay etweenbay hetay irstfay anday econdsay ildrenchay. Histay isay usefulay henway hetay irstfay ildchay isay aay itletay hattay eedsnay ifferentday pacingsay."

# game/indepth_style.rpy:1008
translate piglatin style_box_0c518d9f:

    # e "The box_reverse style property reverses the order of entries in the box."
    e "Hetay ox_reversebay ylestay ropertypay eversesray hetay orderay ofay entriesay inay hetay oxbay."

# game/indepth_style.rpy:1021
translate piglatin style_box_f73c1422:

    # e "We'll switch back to a horizontal box for our next example."
    e "Eway'llay witchsay ackbay otay aay orizontalhay oxbay orfay ouray extnay exampleay."

# game/indepth_style.rpy:1031
translate piglatin style_box_285592bb:

    # e "The box_wrap style property fills the box with children until it's full, then starts again on the next line."
    e "Hetay ox_wrapbay ylestay ropertypay illsfay hetay oxbay ithway ildrenchay untilay itay'say ullfay, hentay artsstay againay onay hetay extnay inelay."

# game/indepth_style.rpy:1044
translate piglatin style_box_a7637552:

    # e "Grids bring with them two more style properties. The xspacing and yspacing properties control spacing in the horizontal and vertical directions, respectively."
    e "Ridsgay ingbray ithway hemtay wotay oremay ylestay ropertiespay. Hetay spacingxay anday spacingyay ropertiespay ontrolcay pacingsay inay hetay orizontalhay anday erticalvay irectionsday, espectivelyray."

# game/indepth_style.rpy:1051
translate piglatin style_box_4006f74b:

    # e "Lastly, we have the fixed layout. The fixed layout usually expands to fill all space, and shows its children from back to front."
    e "Astlylay, eway avehay hetay ixedfay ayoutlay. Hetay ixedfay ayoutlay usuallyay expandsay otay illfay allay pacesay, anday owsshay itsay ildrenchay omfray ackbay otay ontfray."

# game/indepth_style.rpy:1053
translate piglatin style_box_4a2866f0:

    # e "But of course, we have some style properties that can change that."
    e "Utbay ofay oursecay, eway avehay omesay ylestay ropertiespay hattay ancay angechay hattay."

# game/indepth_style.rpy:1062
translate piglatin style_box_66e042c4:

    # e "When the xfit style property is True, the fixed lays out all its children as if it was full size, and then shrinks in width to fit them. The yfit style works the same way, but in height."
    e "Henway hetay fitxay ylestay ropertypay isay Ruetay, hetay ixedfay ayslay outay allay itsay ildrenchay asay ifay itay asway ullfay izesay, anday hentay rinksshay inay idthway otay itfay hemtay. Hetay fityay ylestay orksway hetay amesay ayway, utbay inay eighthay."

# game/indepth_style.rpy:1070
translate piglatin style_box_6a593b10:

    # e "The order_reverse style property changes the order in which the children are shown. Instead of back-to-front, they're displayed front-to-back."
    e "Hetay order_reverseay ylestay ropertypay angeschay hetay orderay inay hichway hetay ildrenchay areay ownshay. Nsteadiay ofay ackbay-otay-ontfray, heytay'eray isplayedday ontfray-otay-ackbay."

# game/indepth_style.rpy:1082
translate piglatin style_inspector_21bc0709:

    # e "Sometimes it's hard to figure out what style is being used for a particular displayable. The displayable inspector can help with that."
    e "Ometimessay itay'say ardhay otay igurefay outay hatway ylestay isay eingbay useday orfay aay articularpay isplayableday. Hetay isplayableday inspectoray ancay elphay ithway hattay."

# game/indepth_style.rpy:1084
translate piglatin style_inspector_243c50f0:

    # e "To use it, place the mouse over a portion of the Ren'Py user interface, and hit shift+I. That's I for inspector."
    e "Otay useay itay, aceplay hetay ousemay overay aay ortionpay ofay hetay Enray'Ypay useray interfaceay, anday ithay iftshay+Iay. Hattay'say Iay orfay inspectoray."

# game/indepth_style.rpy:1086
translate piglatin style_inspector_bcbdc396:

    # e "Ren'Py will pop up a list of displayables the mouse is over. Next to each is the name of the style that displayable uses."
    e "Enray'Ypay illway oppay upay aay istlay ofay isplayablesday hetay ousemay isay overay. Extnay otay eachay isay hetay amenay ofay hetay ylestay hattay isplayableday usesay."

# game/indepth_style.rpy:1088
translate piglatin style_inspector_d981e5c8:

    # e "You can click on the name of the style to see where it gets its properties from."
    e "Ouyay ancay ickclay onay hetay amenay ofay hetay ylestay otay eesay hereway itay etsgay itsay ropertiespay omfray."

# game/indepth_style.rpy:1090
translate piglatin style_inspector_ef46b86d:

    # e "By default, the inspector only shows interface elements like screens, and not images. Type shift+alt+I if you'd like to see images as well."
    e "Ybay efaultday, hetay inspectoray onlyay owsshay interfaceay elementsay ikelay creenssay, anday otnay imagesay. Ypetay iftshay+altay+Iay ifay ouyay'day ikelay otay eesay imagesay asay ellway."

# game/indepth_style.rpy:1092
translate piglatin style_inspector_b59c6b69:

    # e "You can try the inspector right now, by hovering this text and hitting shift+I."
    e "Ouyay ancay ytray hetay inspectoray ightray ownay, ybay overinghay histay exttay anday ittinghay iftshay+Iay."

translate piglatin strings:

    # game/indepth_style.rpy:20
    old "Button 1"
    new "Uttonbay 1"

    # game/indepth_style.rpy:22
    old "Button 2"
    new "Uttonbay 2"

    # game/indepth_style.rpy:66
    old "Style basics."
    new "Tylesay asicsbay."

    # game/indepth_style.rpy:66
    old "General style properties."
    new "Eneralgay ylestay ropertiespay."

    # game/indepth_style.rpy:66
    old "Text style properties."
    new "Exttay ylestay ropertiespay."

    # game/indepth_style.rpy:66
    old "Window and Button style properties."
    new "Indowway anday Uttonbay ylestay ropertiespay."

    # game/indepth_style.rpy:66
    old "Bar style properties."
    new "Arbay ylestay ropertiespay."

    # game/indepth_style.rpy:66
    old "Box, Grid, and Fixed style properties."
    new "Oxbay, Ridgay, anday Ixedfay ylestay ropertiespay."

    # game/indepth_style.rpy:66
    old "The Displayable Inspector."
    new "Hetay Isplayableday Nspectoriay."

    # game/indepth_style.rpy:66
    old "That's all I want to know."
    new "Hattay'say allay Iay antway otay nowkay."

    # game/indepth_style.rpy:112
    old "This text is colored green."
    new "Histay exttay isay oloredcay eengray."

    # game/indepth_style.rpy:126
    old "Danger"
    new "Angerday"

    # game/indepth_style.rpy:142
    old "This text is colored red."
    new "Histay exttay isay oloredcay edray."

    # game/indepth_style.rpy:170
    old "This text is colored blue."
    new "Histay exttay isay oloredcay ueblay."

    # game/indepth_style.rpy:248
    old "Orbiting Earth in the spaceship, I saw how beautiful our planet is.\n–Yuri Gagarin"
    new "Rbitingoay Artheay inay hetay paceshipsay, Iay awsay owhay eautifulbay ouray anetplay isay.\n–Uriyay Agaringay"

    # game/indepth_style.rpy:303
    old "\"Orbiting Earth in the spaceship, I saw how beautiful our planet is.\" Said by Yuri Gagarin."
    new "\"Rbitingoay Artheay inay hetay paceshipsay, Iay awsay owhay eautifulbay ouray anetplay isay.\" Aidsay ybay Uriyay Agaringay."

    # game/indepth_style.rpy:326
    old "Vertical"
    new "Erticalvay"

    # game/indepth_style.rpy:329
    old "Far better it is to dare mighty things, to win glorious triumphs, even though checkered by failure, than to rank with those poor spirits who neither enjoy nor suffer much, because they live in the gray twilight that knows not victory nor defeat.\n\n–Theodore Roosevelt"
    new "Arfay etterbay itay isay otay areday ightymay hingstay, otay inway oriousglay iumphstray, evenay houghtay eckeredchay ybay ailurefay, hantay otay ankray ithway hosetay oorpay piritssay howay eithernay enjoyay ornay uffersay uchmay, ecausebay heytay ivelay inay hetay aygray wilighttay hattay nowskay otnay ictoryvay ornay efeatday.\n\n–Heodoretay Ooseveltray"

    # game/indepth_style.rpy:561
    old "Top Choice"
    new "Optay Hoicecay"

    # game/indepth_style.rpy:566
    old "Bottom Choice"
    new "Ottombay Hoicecay"

    # game/indepth_style.rpy:877
    old "First Child"
    new "Irstfay Hildcay"

    # game/indepth_style.rpy:878
    old "Second Child"
    new "Econdsay Hildcay"

    # game/indepth_style.rpy:879
    old "Third Child"
    new "Hirdtay Hildcay"

    # game/indepth_style.rpy:882
    old "Fourth Child"
    new "Ourthfay Hildcay"

    # game/indepth_style.rpy:883
    old "Fifth Child"
    new "Ifthfay Hildcay"

    # game/indepth_style.rpy:884
    old "Sixth Child"
    new "Ixthsay Hildcay"

